function [yo,fo,to] = sg(x,nfft,Fs,WINDOW,noverlap)

nx = length(x); 
nwind = length(WINDOW);
%La longitud de la ventana tiene que ser menor que la longitud de la seal
if nx < nwind    % si no rellenamos con ceros
    x(nwind)=0;  nx=nwind;
end
x = x(:); 
WINDOW = WINDOW(:);

ncol = fix((nx-noverlap)/(nwind-noverlap));
colindex = 1 + (0:(ncol-1))*(nwind-noverlap);
rowindex = (1:nwind)';
if length(x)<(nwind+colindex(ncol)-1)
    x(nwind+colindex(ncol)-1) = 0;
end
y = zeros(nwind,ncol);
y(:) = x(rowindex(:,ones(1,ncol))+colindex(ones(nwind,1),:)-1);
y = WINDOW(:,ones(1,ncol)).*y;

y = fft(y,nfft); %Transformada discreta de Fourier en el punto nfft
if ~any(any(imag(x)))  
    if rem(nfft,2),   
        select = [1:(nfft+1)/2];
    else
        select = [1:nfft/2+1];
    end
    y = y(select,:);
else
    select = 1:nfft;
end
f = (select - 1)'*Fs/nfft;
t = (colindex-1)'/Fs;
if nargout == 1,
    yo = y;
elseif nargout == 2,
    yo = y;
    fo = f;
elseif nargout == 3,
    yo = y;
    fo = f;
    to = t;
end


